*-------------------------------------------------------------------------------
/* title : Compute short and long-run effects for certain estimated models
   input : $temp/Sample.dta and 
		   $output_dta/TFP_`model'.dta --- point estimates of relevant model
   output: $output_dta/Short&long_run_effects.dta */
*-------------------------------------------------------------------------------

*===============================================================================
* Set up
*===============================================================================
*--------------------------SET-UP & READ DIRECTORIES----------------------------
cd												// Current directory of code
do "[0.0] directories.do"

*===============================================================================
* Compute short- & long-run effects from Baseline model estimates discussed in:
* Introduction; Section 5.1 in Baseline; and Footnote 27
*===============================================================================
qui foreach model in Baseline IV IVnoUS {

	* Load sample and merge point estimates of relevant model
	use "$temp/Sample.dta", clear
	merge m:1 id year using "$output_dta/TFP_`model'.dta", nogen keep(match)
		
	* Regressors of interest in markov process to compute short- and long-run effects
	foreach var of varlist down0dIM up0dEX up0dIM down0dEX IM EX /*shh_dom sub_dom shh_for sub_for */ {
	
		* Compute residual variation for of interest after conditioning on relevant FEs, i.e. within and on top of the FE and TRENDS in Baseline model
		reghdfe L1_`var', a(id i.Gj i.Gc i.Gt i.Gj#c.Gt i.Gc#c.Gt) residuals(L1_`var'_res)
		
		* Standard deviation of residual variation 
		sum L1_`var'_res
		scalar sd_L1_`var'= r(sd)
		
		* Point estimate of persisntence term
		sum rho_omega, mean
		scalar omega = r(mean)
		
		* Short-run effects (in %)
		sum rho_`var', mean
		scalar  SR = r(mean)*sd_L1_`var'*100 
		gen rho_`var'_SR = SR
		
		* Long-run effects (in %)
		sum rho_`var', mean
		scalar  LR = r(mean)*sd_L1_`var'*100/(1-omega)
		gen rho_`var'_LR = LR
	}
	
	* Store relevant variables
	keep *_LR *_SR
	keep if _n==1
	gen model = "`model'"
	order model
	qui compress
	save "$output_dta/Short&long_run_effects_`model'.dta", replace
	
	noi dis "Completed model: `model'"
}

* Append all models
use "$output_dta/Short&long_run_effects_Baseline.dta", clear
append using "$output_dta/Short&long_run_effects_IV.dta"
append using "$output_dta/Short&long_run_effects_IVnoUS.dta"
save "$output_dta/Short&long_run_effects.dta", replace

* Housekeeping
shell erase "$output_dta\Short&long_run_effects_*"
